// TODO: when the player is dead, let him see all players

_maxLines = 23;

_finalText = [];
_groups = [];
_units = [];

_originalSidePlayer = player getVariable "B_originalSide";
if (isNil '_originalSidePlayer') then {
	// player sideChat "no such variable at player";
};

_textForOwnSide = (_originalSidePlayer == scoreboardSide);
_showAll = !(alive player);

// if we are on the page for the player's own side, get together a list of groups
// otherwise, just make a list of units who have done team damage
{
	if (side _x == scoreboardSide) then {
		_originalSide = _x getVariable "B_originalSide";
		if (isNil '_originalSide') then {
			_originalSide = scoreboardSide;
		};

		if (_originalSide == scoreboardSide || _showAll) then {
			if (_textForOwnSide || _showAll) then {
				_grp = group _x;
				if !(_grp in _groups) then {
					_groups set [(count _groups), _grp];
				};
			}
			else {
				// sort out all players who have done some team damage
				_dmg = _x getVariable "B_teamdamage";
				if (_dmg > 0.1) then {
					_units set [(count _units), _x];
				};
			};
		};
	};
} foreach allUnits;

_textColumn = 0;
_linesCount = 0;
_text = "";
scoreboardPageCount = 1;

// put the gathered groups or units into a nice structured text string, coloring team wounders yellow/red
if (_textForOwnSide || _showAll) then {
	scoreboardPageCount = count _groups;
	{
		_units = units _x;

		_col = "#aaccaa";
		_text = _text + format["<t color='%1'>%2</t><br/>", _col, _x];
		_leader = leader _x;
		_leaderCol = "#ffffff";
		_playerCol = "#44dd44";
		{
			if !(alive _x) exitWith {};
			_col = "#aaccaa";
			_leaderStr = "";
			if (_x == _leader) then {
				_col = _leaderCol;
				_leaderStr = " (group leader)"
			};
			if (_x == player) then {
				_col = _playerCol;
			};
			_dmgStr = "";
			_dmg = _x getVariable "B_teamdamage";
			if (_dmg > 0.1) then {
				_col = "#ffff00";
				if (_dmg > 1.0) then {
					_col = "#ff0000";
				};
				_dmgStr = format[" (TD: %1)", _dmg];
			};
			_text = _text + format["<t color='%1'>  %2%3%4</t><br/>", _col, name _x, _dmgStr, _leaderStr];
		} foreach _units;
		_text = _text + "<br/>";

		_finalText set [_textColumn, _text];
		_textColumn = _textColumn + 1;
		_text = "";

	} foreach _groups;
	_finalText set [_textColumn, _text];
} 
else {
	{
		if !(alive _x) exitWith {};
		if (_linesCount > _maxLines) then {
			_finalText set [_textColumn, _text];
			_textColumn = _textColumn + 1;
			_linesCount = 0;
			_text = "";
			scoreboardPageCount = scoreboardPageCount + 1;
		};

		_dmg = _x getVariable "B_teamdamage";
		_col = "#ffff00";
		if (_dmg > 1.0) then {
			_col = "#ff0000";
		};
		_dmgStr = format["(TD: %1)", _dmg];
		_linesCount = _linesCount + 1;
		_text = _text + format["<t color='%1'>%2 %3</t><br/>", _col, name _x, _dmgStr];
	} foreach _units;

	if (count _units == 0) then {
		_text = "Not your side and no units found with team damage."
	};
	_finalText set [_textColumn, _text];
};

_finalText;
