#include "defines.inc"

#define COLOR_BRIGHT { 0.4, 0.55, 0.4, 0.5 }
#define COLOR_DARK { 0.2, 0.26, 0.2, 0.7 }

#define ST_CENTER 2
#define ST_LEFT 0

#define ST_FRAME 64

#define CT_STATIC 0
#define CT_BUTTON 1
#define CT_SLIDER 3
#define CT_STRUCTURED_TEXT 13

// Slider styles
#define SL_DIR 0x400
#define SL_VERT 0
#define SL_HORZ 0x400

#define FontM "TahomaB"

#define BORDER 0.05
#define WIDTH 0.4
#define HEIGHT 0.3

class RscButton {
	idc = -1;
	type = CT_BUTTON;
	style = ST_CENTER;
	default = false;
	font = FontM;
	sizeEx = 0.03;
	colorText[] = { 1, 1, 1, 1 };
	colorFocused[] = COLOR_BRIGHT;   // border color for focused state
	colorDisabled[] = { 0, 0, 1, 0.7 };   // text color for disabled state
	colorBackground[] = COLOR_DARK;
	colorBackgroundDisabled[] = { 1, 1, 1, 0.5 };   // background color for disabled state
	colorBackgroundActive[] = COLOR_BRIGHT;   // background color for active state
	offsetX = 0.002;
	offsetY = 0.002;
	offsetPressedX = 0.001;
	offsetPressedY = 0.001;
	colorShadow[] = { 0, 0, 0, 0.5 };
	colorBorder[] = { 0, 0, 0, 1 };
	borderSize = 0;
	soundEnter[] = { "", 0, 1 };  // no sound
	soundPush[] = { "buttonpushed.ogg", 0.1, 1 };
	soundClick[] = { "", 0, 1 };  // no sound
	soundEscape[] = { "", 0, 1 };  // no sound
	x = 0.0; y = 0.0;
	w = 0.1; h = 0.04;
	text = "Btn";
	action = "";
};

class SlotInButton : RscButton {
	text = "Slot in";
	x = 0.1;
	w = 0.1;
	h = 0.03;
	size = 0.025;
	sizeEx = 0.025;
};

class RscText {
	idc = -1;
	type = CT_STATIC;
	style = ST_LEFT;
	text = "";
	access = 0;
	font = FontM;
	sizeEx = 0.023;
	size = 0.06;

	colorBackground[] = { 0, 0, 0, 0 };
	colorText[] = { 1, 1, 1, 1 };

	x = BORDER;
	y = BORDER;
	w = WIDTH;
	h = HEIGHT;

};


class RscStructuredText {
	type = CT_STRUCTURED_TEXT;
	style = ST_LEFT;
	text = "Loading...";
	access = 0;
	font = FontM;
	sizeEx = 0.023;
	size = 0.03;
	idc = -1;

	//colorBackground[] = COLOR_BRIGHT;
	colorBackground[] = { 0, 0, 0, 0 };
	colorText[] = { 0, 0, 0, 1 };

	x = 0;
	y = 0;
	w = 0.1;
	h = 0.1;

	class Attributes {
		font = "TahomaB";
		color = "#FFFFFF";
		align = "left";
		valign = "middle";
		shadow = "0";
		shadowColor = "#000000"; 
		size = "1";
	};
};

class BtnShowPlayers : RscButton {
	text = "Players";
	x = 0.05;
	y = 0.0;
	w = 0.2;
	action = "[] spawn { closeDialog 0; sleep 0.01; createDialog ""ScoreboardRsc""; call scoreboardCtrl; };";
};


class BtnShowSettings : RscButton {
	text = "Settings";
	x = 0.55;
	y = 0.0;
	w = 0.2;
	action = "closeDialog 0; createDialog ""SettingsRsc"";";
};

class TitleText : RscText {
	idc = -1;
	x = 0.2;
	y = 0.1;
	w = 0.6;
	h = 0.04;
	colorBackground[] = { 0, 0, 0, 0 };
	style = ST_CENTER;
	sizeEx = 0.05;
};

class TicketText : RscText {
	idc = -1;
	x = 0.9;
	y = 0.2;
	w = 0.6;
	h = 0.04;
	colorBackground[] = { 0, 0, 0, 0 };
	style = ST_CENTER;
	sizeEx = 0.05;
};

class Background {
	idc = -1;   // set to -1, unneeded
	type = CT_STATIC;   // constant
	style = ST_LEFT;   // constant
	text = "";
	font = FontM;
	sizeEx = 0.023;

	colorBackground[] = COLOR_DARK;
	colorText[] = { 0, 0, 0, 1 };

	x = 0.05;
	y = 0.05;
	w = 0.9;
	h = 0.9;
};

class ScoreboardRsc {
	idd = SCOREBOARD_IDD;
	movingEnable = 1;
	fadein = 0.0;
	fadeout = 0.0;
	duration = 1e6;
	access = 0;

	class objects {
	};
	class controlsBackground {
		class scoreBG : Background { };
	};
	class controls {
		class LeftArrow : RscButton {
			text = "<<";
			x = 0.1;
			y = 0.1;
			action = "switch (scoreboardSide) do { case ACE_USARMY: { scoreboardSide = sideEnemy; }; case east: { scoreboardSide = ACE_USARMY; }; case resistance: { scoreboardSide = east; }; case civilian: { scoreboardSide = resistance; }; case sideEnemy: { scoreboardSide = resistance; }; }; call scoreboardCtrl;";
		};
		class RightArrow : RscButton {
			text = ">>";
			x = 0.8;
			y = 0.1;
			action = "switch (scoreboardSide) do { case ACE_USARMY: { scoreboardSide = east; }; case east: { scoreboardSide = resistance; }; case resistance: { scoreboardSide = civilian; }; case civilian: { scoreboardSide = sideEnemy; }; case sideEnemy: { scoreboardSide = ACE_USARMY; }; }; call scoreboardCtrl;";
		};

		class BtnShowSettings_ : BtnShowSettings { };

		class BtnShowPlayers_ : BtnShowPlayers { };

		class BtnNextUnits : RscButton {
			text = "Next group";
			x = 0.75;
			y = 0.85;
			w = 0.15;
			action = "scoreboardPage = scoreboardPage + 1; call scoreboardCtrl;";
		};

		class BtnPrevUnits : RscButton {
			text = "Previous group";
			x = 0.55;
			y = 0.85;
			w = 0.15;
			action = "scoreboardPage = scoreboardPage - 1; call scoreboardCtrl;";
		};

		class TitleText_ : TitleText {
			idc = SCOREBOARD_SIDE_IDC;
			text = "BLUFOR";
		};
		
		class TicketText : TitleText {
			idc = SCOREBOARD_TICKET_IDC;
			x = 0.05;
			y = 0.85;
			text = "Tickets: num";
		};
		
		class SB_ColText : RscStructuredText {
			idc = SCOREBOARD_COL0_IDC;
			x = 0.1;
			y = 0.2;
			w = 0.5;
			h = 0.7;
		};
	};
};


class SettingsRsc {
	idd = SETTINGS_IDD;
	movingEnable = 1;
	fadein = 0.0;
	fadeout = 0.0;
	duration = 1e6;
	access = 0;

	onLoad = "_this call settingsCtrl;";

	class objects {
	};
	class controlsBackground {
		class settingsBG : Background { };
	};

	class controls {

		class BtnShowSettings_ : BtnShowSettings { };

		class BtnShowPlayers_ : BtnShowPlayers { };

		class TitleText_ : TitleText {
			text = "Settings";
		};
		
		class ViewDistText : RscText {
			x = 0.5;
			y = 0.3;
			w = 0.2;
			h = 0.04;
			colorBackground[] = { 0, 0, 0, 0 };
			style = ST_LEFT;
			text = "View Distance:";
			sizeEx = 0.03;
		};
		
		class ViewDistSlider : RscText {
			idc = VIEWDISTANCE_IDC;
			type = CT_SLIDER;
			style = SL_HORZ;
			x = 0.7;
			y = 0.3;
			w = 0.15;
			h = 0.04;
			color[] = { 1, 1, 1, 1 };
			coloractive[] = { 1, 0, 0, 0.5 };
			colorBackground[] = { 0, 0, 0, 0 };
			text = "";
			sizeEx = 0.03;
			onSliderPosChanged = "setViewDistance (_this select 1); viewDist = (_this select 1);";
		};
	};
};
